<?php

return [
    'menu' => [
        'addMenu' => 'Add Menu',
        'menuName' => 'Menu Name',
        'allMenus' => 'Menus',
        'chooseMenu' => 'Choose Menu',
        'allMenuItems' => 'Menu Items',
        'menuNameHelp' => 'Enter the menu name below to create a new menu.',
        'item' => 'Item(s)',
        'addMenuItem' => 'Add Menu Item',
        'editMenuItem' => 'Edit Menu Item',
        'itemCategory' => 'Item Category',
        'addItemCategory' => 'Add Item Category',
        'typeVeg' => 'Veg',
        'addItem' => 'Add Item',
        'typeNonVeg' => 'Non Veg',
        'typeEgg' => 'Egg',
        'typeDrink' => 'Drink',
        'typeOther' => 'Other',
        'veg' => 'Veg',
        'non-veg' => 'Non Veg',
        'egg' => 'Contains Egg',
        'itemImage' => 'Item Image',
        'hasVariations' => 'Has Variations',
        'variationName' => 'Variation Name',
        'addVariations' => 'Add Variations',
        'menuItemHelp' => 'Fill in the details below to add a new menu item.',
        'itemName' => 'Item Name',
        'itemDescription' => 'Item Description',
        'categoryName' => 'Item Category Name',
        'setPrice' => 'Price',
        'showVariations' => 'Show Variations',
        'itemVariations' => 'Item Variations',
        'deleteMenuItem' => 'Delete Menu Item',
        'deleteItemCategory' => 'Delete Item Category',
        'deleteVariant' => 'Delete Variant',
        'deleteMenu' => 'Delete Menu',
        'deleteVariantMessage' => 'Are you sure you want to delete the item variant?',
        'deleteMenuItemMessage' => 'Are you sure you want to delete the menu item?',
        'deleteMenuMessage' => 'Are you sure you want to delete the menu?',
        'deleteCategoryMessage' => 'Are you sure you want to delete the item category?',
        'filterType' => 'Filter by Type',
        'filterCategory' => 'Filter by Category',
        'itemType' => 'Item Type',
        'addItem' => 'Add Item',
        'preparationTime' => 'Preparation Time',
        'minutes' => 'Minutes',
        'browseMenu' => 'Browse Menu',
        'isAvailable' => 'Is Available',
        'filterAvailability' => 'Filter by Availability',
        'itemAvailability' => 'Item Availability',
        'available' => 'Available',
        'notAvailable' => 'Not Available',
        'drink' => 'Drink',
        'addCustomer' => 'Add Customer',
        'translations' => 'Translations',
        'notTranslated' => 'Not Translated',
        'selectLanguage' => 'Select Language',
    ],

    'table' => [
        'allAreas' => 'All Areas',
        'addArea' => 'Add Area',
        'editArea' => 'Edit Area',
        'areaName' => 'Area Name',
        'noOfTables' => 'No Of Tables',
        'deleteArea' => 'Delete Area',
        'deleteAreaMessage' => 'Are you sure you want to delete the area?',
        'seats' => 'Seat(s)',
        'addTable' => 'Add Table',
        'editTable' => 'Edit Table',
        'tableView' => 'Table View',
        'tableCode' => 'Table Code',
        'chooseArea' => 'Choose Area',
        'seatingCapacity' => 'Seating Capacity',
        'table' => 'Table',
        'available' => 'Available',
        'running' => 'Running',
        'reserved' => 'Reserved',
        'filterAvailable' => 'Filter by Availability',
        'availableTables' => 'Available Tables',
        'deleteTable' => 'Delete Table?',
        'deleteTableMessage' => 'Are you sure you want to delete the table?',
        'selectTable' => 'Select Table',
        'tableAvailability' => 'Table Availability',
        'generateQrCode' => 'Generate QR Code',
    ],

    'order' => [
        'qty' => 'QTY',
        'price' => 'Price',
        'amount' => 'Amount',
        'balanceReturn' => 'Balance Returned',
        'noOfPax' => 'Pax',
        'selectWaiter' => 'Select Waiter',
        'selectDeliveryExecutive' => 'Select Delivery Executive',
        'totalItem' => 'Item(s)',
        'subTotal' => 'Sub Total',
        'total' => 'Total',
        'totalOrder' => 'Total Orders',
        'orderNumber' => 'Order',
        'select' => 'Select',
        'setTable' => 'Assign Table',
        'kot' => 'KOT',
        'kotAndPrint' => 'KOT & Print',
        'print_kot' => 'Print KOT',
        'newKot' => 'New KOT',
        'bill' => 'BILL',
        'draft' => 'Waiting KOT',
        'billed' => 'Billed',
        'paid' => 'Paid',
        'payment_due' => 'Payment Due',
        'canceled' => 'Canceled',
        'infodraft' => 'Not sent to Kitchen',
        'infokot' => 'Cooking Now',
        'infobilled' => 'Waiting for Payment',
        'infopaid' => 'Payment Done',
        'infopayment_due' => 'Payment is Pending',
        'infocanceled' => 'Order Canceled',
        'addCustomerDetails' => 'Add Customer Details',
        'addPayment' => 'Add Payment',
        'addItems' => 'Add Items',
        'waiter' => 'Waiter',
        'in_kitchen' => 'In Kitchen',
        'food_ready' => 'Food is Ready',
        'served' => 'Food is Served',
        'addNote' => 'Add Note',
        'orderNote' => 'Order Note',
        'cancelKot' => 'Cancel KOT',
        'cancelKotMessage' => 'This will cancel the KOT.',
        'showOrder' => 'Show Order',
        'cash' => 'Cash',
        'card' => 'Card',
        'upi' => 'UPI',
        'due' => 'Due',
        'other' => 'Other',
        'payViaCash' => 'Pay via Cash',
        'payViacard' => 'Pay via Card',
        'payViaupi' => 'Pay via UPI',
        'returnAmount' => 'Amount to be returned',
        'payableAmount' => 'Payable Amount',
        'dueAmount' => 'Due Amount',
        'paymentMethod' => 'Payment Method',
        'taxes' => 'Taxes',
        'viewCart' => 'View Cart',
        'placeOrder' => 'Place Order',
        'myOrders' => 'My Orders',
        'includeTax' => 'Includes Taxes',
        'payNow' => 'Pay Now',
        'payLater' => 'Pay Later',
        'payViaQr' => 'Pay via QR Code',
        'chooseGateway' => 'Choose payment gateway',
        'razorpay' => 'Razorpay',
        'stripe' => 'Stripe',
        'offline' => 'Offline',
        'transactionId' => 'Transaction ID',
        'cancelOrder' => 'Cancel Order',
        'cancelOrderMessage' => 'This will cancel the Order.',
        'activeOrder' => 'Active Orders',
        'todayOrder' => 'Today Orders',
        'dine_in' => 'Dine In',
        'delivery' => 'Delivery',
        'pickup' => 'Pickup',
        'out_for_delivery' => 'Out For Delivery',
        'infoout_for_delivery' => 'Order is out for delivery',
        'delivered' => 'Delivered',
        'infodelivered' => 'Order is Delivered',
        'newOrder' => 'New Order',
        'splitBill' => 'Split Bill',
        'fullPayment' => 'Full Payment',
        'splitByItems' => 'Split by Items',
        'availableItems' => 'Available Items',
        'clickToAdd' => 'Click item to add to split',
        'itemsInSplit' => 'Items in Split',
        'noItemsInSplit' => 'No items added to this split yet',
        'newSplit' => 'New Split',
        'changeMethod' => 'Change Method',
        'equalSplit' => 'Equal Split',
        'splitEqually' => 'Split equally',
        'customSplit' => 'Custom Split',
        'splitByAmount' => 'Split by amount',
        'splitByDishes' => 'Split by dishes',
        'base' => 'Base',
        'tax' => 'Tax',
        'payment' => 'Payment',
        'orderHash' => 'Order #',
        'totalBill' => 'Total Bill',
        'amountPaid' => 'Amount Paid',
        'splitAmount' => 'Split Amount',
        'remaining' => 'Remaining',
        'quantity' => 'Quantity',
        'remove' => 'Remove',
        'completePayment' => 'Complete Payment',
        'createBillAndPrintReceipt' => 'Bill & Print',
        'billAndPayment' => 'Bill & Payment',
        'discount' => 'Discount',
        'addDiscount' => 'Add Discount',
        'discountType' => 'Discount Type',
        'fixed' => 'Fixed',
        'percent' => 'Percent',
        'discountValue' => 'Discount Value',
        'enterDiscountValue' => 'Enter Discount Value',
        'calculatedDiscount' => 'Calculated Discount',
        'noOrderType' => 'Orders Disabled',
        'enableOrderType' => 'You need to enable orders in settings to start taking orders',
        'enableOrderTypeButton' => 'Enable Orders',
        'deleteOrder' => 'Delete Order',
        'deleteOrderMessage' => 'Are you sure you want to delete the order?',
        'deliveryExecutive' => 'Delivery Executive',
        'selectOrderTypes' => 'Select Order Types',
        'extraCharges' => 'Charges',
    ],

    'customer' => [
        'addCustomer' => 'Add Customer',
        'name' => 'Customer Name',
        'phone' => 'Phone',
        'email' => 'Email Address',
        'customerAddress' => 'Customer Address',
        'address' => 'Address',
        'enterName' => 'Please enter your name',
        'enterCustomerName' => 'Please enter customer name',
        'editCustomer' => 'Edit Customer',
        'deleteCustomer' => 'Delete Customer',
        'deleteWithOrder' => 'Delete with their Orders',
        'deleteCustomerMessage' => 'Are you sure you want to delete the customer?',
        'customer' => 'Customer',
        'importCustomer' => 'Import Customer',
    ],

    'settings' => [
        'appSettings' => 'App Settings',
        'restaurantInformation' => 'Restaurant Information',
        'restaurantName' => 'Restaurant Name',
        'restaurantPhoneNumber' => 'Restaurant Phone Number',
        'restaurantEmailAddress' => 'Restaurant Email Address',
        'restaurantAddress' => 'Restaurant Address',
        'generalHelp' => 'Enter the general information about your restaurant.',
        'countryTimezone' => 'Restaurant\'s Country, Timezone & Currency',
        'restaurantCountry' => 'Country',
        'restaurantTimezone' => 'Time Zone',
        'showTax' => 'Show Tax Id on Orders',
        'addMore' => 'Add More',
        'addTax' => 'Add Tax',
        'restaurantCurrency' => 'Currency',
        'themeColor' => 'Theme Color',
        'themeSettings' => 'Theme Settings',
        'restaurantLogo' => 'Restaurant Logo',
        'uploadLogo' => 'Upload Logo',
        'removeLogo' => 'Remove Logo',
        'paymentgatewaySettings' => 'Payment Gateways',
        'paymentHelp' => 'Enter payment gateway credentials to receive order payments.',
        'paymentHelpSuperadmin' => 'Enter payment gateway credentials to receive subscription payments.',
        'enableRazorpay' => 'Enable Razorpay',
        'enableStripe' => 'Enable Stripe',
        'enableOfflinePayment' => 'Pay Offline',
        'enableQrPayment' => 'Pay Via Qr Code',
        'restaurantSettings' => 'Restaurant Information',
        'taxSettings' => 'Taxes',
        'currencySettings' => 'Currencies',
        'offline_payment_status' => 'Enable Offline Payment',
        'roleSettings' => 'Staff Roles',
        'reservationSettings' => 'Reservation Settings',
        'languageSettings' => 'Language Settings',
        'currencySymbol' => 'Currency Symbol',
        'currencyCode' => 'Currency Code',
        'editCurrency' => 'Edit Currency',
        'addCurrency' => 'Add Currency',
        'deleteCurrency' => 'Delete Currency',
        'deleteCurrencyMessage' => 'Are you sure you want to delete the Currency?',
        'deleteTaxMessage' => 'Are you sure you want to delete the Tax?',
        'taxName' => 'Tax Name',
        'taxPercent' => 'Tax Percent',
        'taxId' => 'Tax ID',
        'addTax' => 'Add Tax',
        'deleteTax' => 'Delete Tax',
        'editTax' => 'Edit Tax',
        'emailSettings' => 'Email Settings',
        'mailFromName' => 'Mail From Name',
        'mailFromEmail' => 'Mail From Email',
        'enableQueue' => 'Enable Email Queue',
        'mailDriver' => 'Mail Driver',
        'smtpHost' => 'SMTP Host',
        'smtpPort' => 'SMTP Port',
        'smtpEncryption' => 'SMTP Mail Encryption',
        'mailUsername' => 'Mail Username',
        'mailPassword' => 'Mail Password',
        'notificationSettings' => 'Notification Settings',
        'branchSettings' => 'Branch Settings',
        'addBranch' => 'Add Branch',
        'editBranch' => 'Edit Branch',
        'branchName' => 'Branch Name',
        'branchAddress' => 'Branch Address',
        'deleteBranch' => 'Delete Branch',
        'branches' => 'Branches',
        'deleteBranchMessage' => 'Are you sure you want to delete the Branch? All the orders, staff members and payments related to this branch will be deleted.',
        'upgradeLicense' => 'Upgrade Plan',
        'licenseType' => 'License Type',
        'upgradeLicenseInfo' => 'Simple, transparent pricing with everything you need to run your restaurant smoothly.',
        'pricing' => 'Pricing',
        'payNow' => 'Pay Now',
        'paymentSource' => 'Payment Source',
        'appName' => 'App Name',
        'paymentUpgradeHeading' => 'Upgrade to Accept Payments Seamlessly',
        'paymentUpgradeInfo' => 'Take your restaurant\'s efficiency to the next level by integrating Payment Gateways. Upgrade now to offer your customers secure, fast, and convenient payment options like Stripe and Razorpay',
        'themeUpgradeHeading' => 'Upgrade for a Personalized Brand Experience',
        'themeUpgradeInfo' => 'Stand out with your unique brand identity! Upgrade now to customize your Theme Colors and add your Business Logo, creating a seamless experience that reflects your restaurant\'s personality.',
        'manageTranslations' => 'Manage Translations',
        'customerLoginRequired' => 'Customer need to login to place order?',
        'customerName' => 'Show Customer Name',
        'customerAddress' => 'Show Customer Address',
        'tableNumber' => 'Table no.',
        'paymentQrCode' => 'Show QR code    ',
        'waiter' => 'Show Waiter Name',
        'totalGuest' => 'Show Total guest',
        'restaurantLogo' => 'Show Restaurant Logo',
        'restaurantTax' => 'Show Restaurant Tax',
        'noTaxFound' => 'No Tax Found',
        'selectEnvironment' => 'Select Environment',
        'enablePushNotification' => 'Enable Push Notifications',
        'pushNotificationSettings' => 'Push Notification Settings',
        'aboutUsSettings' => 'About Us',
        'customerSiteSettings' => 'Customer Site',
        'receiptSetting' => 'Receipt Settings',
        'allowCustomerDeliveryOrders' => 'Allow Customer to place Delivery Orders',
        'allowCustomerOrders' => 'Allow Customer to place Orders',
        'allowCustomerPickupOrders' => 'Allow Customer to place Pickup Orders',
        'disableLandingSite' => 'Disable Landing Site',
        'disableLandingSiteHelp' => 'Disable the landing site or set your custom landing site.',
        'landingSiteType' => 'Landing Site Type',
        'landingSiteUrl' => 'Landing Site URL',
        'theme' => 'Theme',
        'custom' => 'Custom',
        'billing' => 'Billing',
        'package' => 'Package',
        'isWaiterRequestEnabled' => 'Enable Waiter Request',
        'dineInOnlinePaymentRequired' => 'Dine-in: Online payment required',
        'deliveryOnlinePaymentRequired' => 'Delivery: Online payment required',
        'pickupOnlinePaymentRequired' => 'Pickup: Online payment required',
        'enableRazorpayOrStripe' => 'Please enable Razorpay or Stripe to configure service-specific online payment options.',
        'generalSettingsUseInfo' => 'Enabling this allows only online payments via the active gateway. If disabled, both online and cash payments are accepted with an active gateway.',
        'defaultReservationStatus' => 'Default Table Reservation Status',
        'reservationStatusConfirmed' => 'Confirmed',
        'reservationStatusCheckedIn' => 'Checked In',
        'reservationStatusCancelled' => 'Cancelled',
        'reservationStatusPending' => 'Pending',
        'reservationStatusNoShow' => 'No Show',
        'receipt' => 'receipt Setting',
        'facebook_link' => 'Facebook Link',
        'instagram_link' => 'Instagram Link',
        'twitter_link' => 'Twitter Link',
        'yelp_link' => 'Yelp Link',
        'tableRequiredDineIn' => 'Table Required for Dine-In',
        'allowDineIn' => 'Allow Dine-In',
        'defaultLanguage' => 'Default Language',
        'defaultCurrency' => 'Default Currency',
        'storageSettings' => 'Storage Settings',
        'selectStorage' => 'Select Storage',
        'localStorageNote' => 'Local storage is the default storage option. It stores files on the server\'s local disk.',
        'storageSuggestion' => '<b>Recommendation:</b> Consider using <a href="https://digitalocean.pxf.io/froiden" class="underline" target="_blank">DigitalOcean Spaces</a>, <a href="https://aws.amazon.com/s3" class="underline" target="_blank">AWS S3</a>, <a href="https://wasabi.com" class="underline" target="_blank">Wasabi</a> or <a href="https://min.io/" class="underline" target="_blank">MinIO</a> Storage for an additional layer of security',
        'digitaloceanAccessKey' => 'DigitalOcean Access Key',
        'digitaloceanSecretKey' => 'DigitalOcean Secret Key',
        'digitaloceanBucket' => 'DigitalOcean Bucket',
        'digitaloceanRegion' => 'DigitalOcean Region',
        'minioAccessKey' => 'Minio Access Key',
        'minioSecretKey' => 'Minio Secret Key',
        'minioBucket' => 'Minio Bucket',
        'minioRegion' => 'Minio Region',
        'minioEndpoint' => 'Minio Endpoint',
        'wasabiAccessKey' => 'Wasabi Access Key',
        'wasabiSecretKey' => 'Wasabi Secret Key',
        'wasabiBucket' => 'Wasabi Bucket',
        'wasabiRegion' => 'Wasabi Region',
        'awsAccessKey' => 'AWS Key ID',
        'awsSecretKey' => 'AWS Access Key',
        'awsBucket' => 'AWS Bucket',
        'awsRegion' => 'AWS Region',
        'testStorage' => 'Test Storage',
        'testStorageFile' => 'Upload file to test if it gets uploaded to bucket',
        'moveFilesToCloud' => 'Move Files to Cloud',
        'local' => 'Local',
        'digitalocean' => 'DigitalOcean',
        'aws_s3' => 'AWS S3',
        'wasabi' => 'Wasabi',
        'minio' => 'MinIO',
        'currencyFormat' => 'Currency Format',
        'currencyPosition' => 'Currency Position',
        'thousandSeparator' => 'Thousand Separator',
        'decimalSeparator' => 'Decimal Separator',
        'numberOfdecimals' => 'Number of Decimals',
        'left' => 'Left',
        'right' => 'Right',
        'leftWithSpace' => 'Left with Space',
        'rightWithSpace' => 'Right with Space',
        'deleteTax' => 'Are you Sure, you wan to delete this Tax?',
        'deleteTaxMessage' => 'Delete tax permanently',
        'showLogoText' => 'Show Restaurant Name with Logo',
        'socialMediaLinks' => 'Social Media Links',
        'facebook' => 'Facebook',
        'instagram' => 'Instagram',
        'twitter' => 'Twitter',
        'facebookPlaceHolder' => 'Enter your Facebook URL',
        'instagramPlaceHolder' => 'Enter your Instagram URL',
        'twitterPlaceHolder' => 'Enter your Twitter URL',
        'tableRequiredDineIn' => 'Table Required for Dine-In',
        'tableRequiredDineInDescription' => 'Enable this to require customers to select a table for dine-in orders.',
        'defaultReservationStatusDescription' => 'Select the default status for new reservations.',
        'allowCustomerPickupOrdersDescription' => 'Enable this to allow customers to place pickup orders.',
        'allowCustomerDeliveryOrdersDescription' => 'Enable this to allow customers to place delivery orders.',
        'allowCustomerDineInOrdersDescription' => 'Enable this to allow customers to place dine-in orders.',
        'allowCustomerOrdersDescription' => 'Enable this to allow customers to place orders.',
        'allowDineInDescription' => 'Enable this to allow dine-in orders.',
        'customerLoginRequiredDescription' => 'Enable this to require customers to login before placing orders.',
        'isWaiterRequestEnabledDescription' => 'Enable this to allow customers to call waiters for service.',
        'orderSettings' => 'Order Settings',
        'orderSettingsDescription' => 'Configure settings related to customer orders.',
        'dineInSettings' => 'Dine-in Settings',
        'customerSiteSettingsDescription' => 'Configure settings related to the customer site.',
        'qrCodeImage' => 'Upload QR Code Image',
        'qrCodeRequirements' => 'Upload a QR code image for payment. The image should be a clear, high-quality image of the QR code.',
        'qrPaymentDescription' => 'Enable this to allow customers to pay via QR code.',
        'uploadQrCode' => 'Upload QR Code',
        'logoDescription' => 'Upload a logo for your restaurant.',
        'showLogoTextDescription' => 'Enable this to show the restaurant name with the logo.',
        'customerInformation' => 'Customer Information',
        'receiptPreview' => 'Receipt Preview',
        'previewReceipt' => 'Preview Receipt',
        'orderDetails' => 'Order Details',
        'cronJobSetting' => 'Cron Job Setting',
        'customModules' => 'Custom Modules',
        'installCustomModule' => 'Install Custom Module',
        'enablePayViaCash' => 'Pay Via Cash',
        'seo' => 'SEO',
        'metaKeyword' => 'Meta Keyword',
        'metaDescription' => 'Meta Description',
        'offlinePaymentDescription' => 'Enable this to allow customers to pay via offline payment methods.',
        'offlinePaymentDetailsDescription' => 'Enable this to allow customers to pay via offline payment methods.',
        'offlinePaymentDetails' => 'Offline Payment Details',
        'cashPaymentDescription' => 'Enable this to allow customers to pay via cash payment methods.',
        'restaurantRequiresApproval' => 'Restaurant Requires Approval',
        'restaurantRequiresApprovalInfo' => 'Enable this to require admin approval for new restaurant registrations.',
        'themeColorDescription' => 'Select the theme color for your restaurant.',
        'upload_fav_icon_android_chrome_192' => 'Upload Favicon for Android Chrome (192x192)px',
        'upload_fav_icon_android_chrome_512' => 'Upload Favicon for Android Chrome (512x512)px',
        'upload_fav_icon_apple_touch_icon' => 'Upload Favicon for Apple Touch Icon',
        'upload_favicon_16' => 'Upload Favicon (16x16)px',
        'upload_favicon_32' => 'Upload Favicon (32x32)px',
        'favicon' => 'Upload Favicon',
        'editCharge' => 'Edit Charge',
        'addCharge' => 'Add Charge',
        'chargeName' => 'Charge Name',
        'chargeType' => 'Type',
        'percent' => 'Percent',
        'fixed' => 'Fixed',
        'rate' => 'Rate',
        'orderType' => 'Order Type',
        'deleteCharge' => 'Delete Charge',
        'deleteChargeMessage' => 'Are you sure you want to delete the charge?',
        'hideTodayOrders' => 'Hide Today Orders',
        'hideNewReservation' => 'Hide New Reservation',
        'hideNewWaiterRequest' => 'Hide New Waiter Request',
        'hideTopNav' => 'Hide Top Navigation',
        'hideTodayOrdersDescription' => 'Enable this to hide today orders widget from top navigation.',
        'hideNewReservationDescription' => 'Enable this to hide new reservation widget from top navigation.',
        'hideNewWaiterRequestDescription' => 'Enable this to hide new waiter request widget from top navigation.',
        'charges' => 'Additional Charges',
        'onDesktop' => 'On Desktop',
        'onMobile' => 'On Mobile',
        'openViaQrCode' => 'Only When Open via QR Code',
        'callWaiterSettings' => 'Call Waiter Settings',
        'onDesktopDescription' => 'Enable this to allow customers to call waiters on desktop.',
        'onMobileDescription' => 'Enable this to allow customers to call waiters on mobile.',
        'openViaQrCodeDescription' => 'Enable this to allow customers to call waiters only when they open the app via QR code.',
        'favicons' => 'Favicons',
        'faviconsDescription' => 'Upload a favicon for your site.',
        'generateFavicon' => 'Generate Favicon',
        'siteWebManifest' => 'Site Web Manifest',
        'paymentDetails' => 'Payment Details',
        'paymentQrImage' => 'Payment QR Image',
        'uploadPaymentQrCode' => 'Upload Payment QR Code',
        'showPaymetQrCode' => 'Show Payment QR Code',
        'payFromYourPhone' => 'PAY FROM YOUR PHONE',
        'scanQrCode' => 'Scan the QR code to pay Your Bill ',
        'isChargeEnabled' => 'Apply Charge',
        'isChargeEnabledDescription' => 'Check to enable this charge.',
        'pwaSettings' => 'PWA Settings',
        'enbalePwaApp' => 'Enable PWA App',
        'enablePwadescription' => 'Enable this to allow customers to install your app on their devices.',
        'metaTitle' => 'Meta Title',
    ],

    'dashboard' => [
        'todayOrderCount' => 'Today\'s Orders',
        'todayEarnings' => 'Today\'s Earnings',
        'sinceYesterday' => 'Since yesterday',
        'todayStats' => 'Statistics',
        'todayCustomerCount' => 'Today\'s Customer',
        'averageDailyEarning' => 'Average Daily Earnings',
        'sincePreviousMonth' => 'Since Previous Month',
        'earnings' => 'Earnings',
        'salesThisMonth' => 'Sales This Month',
        'topTables' => 'Top Selling Tables',
        'topDish' => 'Top Selling Dish',
        'todayRestaurantCount' => 'Today\'s Restaurant Count',
        'totalRestaurantCount' => 'Total Restaurant Count',
        'totalFreeRestaurantCount' => 'Total Free Restaurant Count',
        'totalPaidRestaurantCount' => 'Total Paid Restaurant Count',
        'verificationPendingInfo' => 'Your restaurant is pending verification. Please wait for admin approval.',
        'verificationPending' => 'Verification Pending',
        'verificationPendingDescription' => 'Restaurant is waiting for approval',
        'verificationRejectedInfo' => 'Your restaurant verification has been rejected. Please contact admin for more details.',
        'approvalStatus' => 'Approval Status',

    ],

    'update' => [
        'systemDetails' => 'System Details',
        'updateTitle' => 'Update To New Version',
        'updateDatabase' => 'Update Database',
        'fileReplaceAlert' => 'To update the TableTrack to the new version check documentation for the instructions.',
        'updateDatabaseButton' => 'Click to update database',
        'newUpdate' => 'New update available',
        'updateNow' => 'Update Now',
        'updateAlternate' => 'If the <b>Update Now</b> button does not work then follow the <b> <a href="https://froiden.freshdesk.com/support/solutions/articles/43000554421-update-application-manually" target="_blank">Manual update</a></b> instructions as mentioned in the documentation.',
        'updateManual' => 'Update Alternate Method',
        'updateFiles' => 'Update Files',
        'install' => 'Install',
        'downloadUpdateFile' => 'Download Update File',
        'moduleFile' => 'Once the zip file is uploaded, you will see a list of modules available for installation or update. To proceed with the installation or update, simply click on the "install" button for the respective module. Please note that after clicking the "install" button, you will be logged out. Once the installation is complete, you will be able to see the module on the module list. You can activate or deactivate the module from the list at any time.',
        'customModules' => 'Custom Modules',
        'customModulesDescription' => 'Custom modules are additional features that can be added to your restaurant. They are installed as separate modules and can be activated or deactivated at any time.',
        'customModulesList' => 'Custom Modules List',
        'installCustomModule' => 'Install Custom Module',
        'uploadModule' => 'Upload Module',
        'downloadFilefromCodecanyon' => 'Download file from Codecanyon',
        'moduleFileItem' => 'Module File Item',
        'moduleFileItemDescription' => 'Module File Item Description',
    ],

    'staff' => [
        'addStaff' => 'Add Member',
        'name' => 'Member Name',
        'email' => 'Email Address',
        'enterName' => 'Please enter your name',
        'editMember' => 'Edit Member',
        'deleteMember' => 'Delete Member',
        'deleteMemberMessage' => 'Are you sure you want to delete the member?',
        'photo' => 'Photo',
        'addExecutive' => 'Add Executive',
        'available' => 'Available',
        'on_delivery' => 'On Delivery',
        'inactive' => 'Inactive',
        'editExecutive' => 'Edit Executive',
        'password' => 'Password',
        'Branch Head' => 'Branch Head',
        'Waiter' => 'Waiter',
        'Chef' => 'Chef',
        'Admin' => 'Admin',
        'Super Admin' => 'Super Admin',
        'Branch Head' => 'Branch Head',
    ],

    'reservation' => [
        'slotType' => 'Slot Type',
        'timeStart' => 'Start Time',
        'timeEnd' => 'End Time',
        'timeSlotDifference' => 'Time Slot Difference',
        'available' => 'Available',
        'unavailable' => 'Unavailable',
        'maxGuests' => 'Maximum Guests',
        'guests' => 'Guests',
        'Lunch' => 'Lunch',
        'Breakfast' => 'Breakfast',
        'Dinner' => 'Dinner',
        'No_Show' => 'No Show',
        'Checked_In' => 'Checked In',
        'Confirmed' => 'Confirmed',
        'Cancelled' => 'Cancelled',
        'Pending' => 'Pending',
        'todayReservations' => 'Today Reservations',
        'newReservations' => 'New Reservations',
        'newReservation' => 'New Reservation',
        'selectDate' => 'Select Date of Booking',
        'upgradeHeading' => 'Unlock Seamless Table Reservations Today!',
        'upgradeInfo' => 'Effortlessly manage customer reservations with Table Reservation feature. Upgrade now and give your guests the convenience they deserve, while streamlining your operations.',
        'reservedTables' => 'Reservations',
    ],

    'notifications' => [
        'order_received' => 'New Order Received',
        'order_received_info' => 'Restaurant admin will receive an email when a new order is placed by the customer.',
        'reservation_confirmed' => 'Reservation Confirmation',
        'reservation_confirmed_info' => 'Customer will receive an email after making the reservation.',
        'new_reservation' => 'New Reservation Received',
        'new_reservation_info' => 'Restaurant admin will receive an email when a new reservation is made by the customer.',
        'order_bill_sent' => 'Order Bill',
        'order_bill_sent_info' => 'Customer will receive the order bill via email.',
        'staff_welcome' => 'Staff Welcome Email',
        'staff_welcome_info' => 'Staff Member will welcome email when you add a new staff member.',
    ],

    'onboarding' => [
        'completeSteps' => 'Complete following steps to get started',
        'markComplete' => 'Mark Complete',
        'addBranchHeading' => 'Add Branch Information',
        'addBranchInfo' => 'Provide the essential details of your restaurant branch.',
        'addAreaHeading' => 'Set Up Your Restaurant Areas',
        'addAreaInfo' => 'Create distinct areas like dining rooms, patios, or bars to organize your tables.',
        'addTableHeading' => 'Add a Table to the Area',
        'addTableInfo' => 'Assign and name the tables in each area for easy tracking during reservations and orders.',
        'addMenuHeading' => 'Build Your Menu',
        'addMenuInfo' => 'Let\'s build your menu! First add a name to your menu like Drinks, Breakfast etc.',
        'addMenuItemHeading' => 'Add Items to Your Menu',
        'addMenuItemInfo' => 'Add individual dishes with their descriptions and prices to complete your menu.',
        'addOrderHeading' => 'Test Your Order Process',
        'addOrderInfo' => 'Make sure everything works by placing a test order for your setup.',
    ],

    'restaurant' => [
        'addRestaurant' => 'Add Restaurant',
        'name' => 'Restaurant Name',
        'email' => 'Email Address',
        'editRestaurant' => 'Edit Restaurant',
        'deleteRestaurant' => 'Delete Restaurant',
        'deleteRestaurantMessage' => 'Are you sure you want to delete the restaurant?',
        'logo' => 'Logo',
        'phone' => 'Phone',
        'restaurantDetails' => 'Restaurant Details',
        'restaurantBranchDetails' => 'Add Restaurant Branch Details',
        'changePassword' => 'Change Password',
        'firstAdmin' => 'First Admin',
        'nextBranchDetails' => 'Next: Branch Details',
        'updatePackage' => 'Update Package',
        'needApproval' => 'Need Approval',
        'resetFilter' => 'Reset Filter',
        'rejectionReason' => 'Rejection Reason',
        'currentPackage' => 'Current Package',
        'rejectionReasonPlaceholder' => 'Provide a reason for rejection',
    ],

    'package' => [
        'packageName' => 'Package Name',
        'description' => 'Description',
        'monthlyPrice' => 'Monthly Price',
        'annualPrice' => 'Annual Price',
        'annually' => 'Annually',
        'monthly' => 'Monthly',
        'trialDays' => 'Trial Days',
        'trialStatus' => 'Trial Status',
        'NotificationBeforeDays' => 'Notification Before Days',
        'trialMessage' => 'Trial Message',
        'lifetimePrice' => 'Lifetime Price',
        'packagePrice' => 'Package Price',
        'selectBillingCycle' => 'Select Billing Cycle',
        'packageType' => 'Package Type',
        'annual' => 'Annual',
        'free' => 'Free',
        'default' => 'Default',
        'private' => 'Private',
        'trial' => 'Trial',
        'lifetime' => 'Lifetime',
        'moduleInPackage' => 'Modules in Package',
        'daysLeftTrial' => 'days left on trial',
        'trialExpired' => 'Trial expired',
        'selectPackage' => 'Select Package',
        'normal' => 'Normal',
        'trialDays' => 'Trial Days',
        'addPackage' => 'Add Package',
        'editPackage' => 'Edit Package',
        'freePlan' => 'Free Plan',
        'recommended' => 'Recommended',
        'trialPackage' => 'Trial Package',
        'monthlyRazorpayId' => 'Monthly Razorpay Id',
        'annualRazorpayId' => 'Annual Razorpay Id',
        'lifetimeRazorpayId' => 'Lifetime Razorpay Id',
        'lifetimeStripeId' => 'Lifetime Stripe Id',
        'monthlyStripeId' => 'Monthly Stripe Id',
        'annualStripeId' => 'Annual Stripe Id',
        'selectAdditionalFeature' => 'Select Additional Feature',
        'trialPackageDetails' => 'If this package is active, then the restaurant which registers for the first time goes to this package.',
        'defaultPackage' => 'Default Package',
        'defaultPackageDetails' => 'When the trial package expires, the restaurant goes back to this plan.',
        'defaultPackageDetails2' => 'When the restaurant fails the payment of an upgraded package, the restaurant goes back to this plan.',
        'thisPackageCannotBeDeleted' => 'This package cannot be deleted',
        'planExpire' => 'If your plan expires you will be assigned this package.',
        'trialPeriod' => 'Trial Period',
        'days' => 'Day(s)',
        'private' => 'Private',
        'freePlan' => 'Free Plan',
        'paidPlan' => 'Paid Plan',
        'choosePackageType' => 'Choose Package Type',
        'monthlyPlan' => 'Monthly Plan',
        'choseFreePlan' => 'Choose Free Plan',
        'currentPlan' => 'Current Plan',
        'chooseDefaultPlan' => 'Choose Default Plan',
        'active' => 'Active',
        'inactive' => 'Inactive',
        'annualPlan' => 'Annual Plan',
        'monthlyPrice' => 'Monthly Plan Price',
        'annualPrice' => 'Annual Plan Price',
        'isPrivate' => 'Make Private',
        'selectModules' => 'Select Modules for this package',
        'selectAll' => 'Select All',
        'deletePackage' => 'Delete Package',
        'deletePackageMessage' => 'Are you sure you want to delete the package?',
        'isRecommended' => 'Mark as Recommended',
        'restaurantCurrentPackage' => 'Restaurant\'s Current Package',
        'updatePackage' => 'Update Package',
        'packageDetails' => 'Package Details',
        'transactionId' => 'Transaction ID',
        'paymentGateway' => 'Payment Gateway',
        'choosePlan' => 'Choose Plan',
        'noPaymentOptionEnable' => 'No payment options are enabled.',
        'choosePaymentMethod' => 'Choose Payment Method',
        'amount' => 'Amount',
        'paymentBy' => 'Payment By',
        'created' => 'Created',
        'status' => 'Status',
        'receipt' => 'Receipt',
        'paymentDate' => 'Payment Date',
        'payOnline' => 'Pay Online',
        'billingCycle' => 'Billing Cycle',
        'payOffline' => 'Pay Offline',
        'purchaseHistory' => 'Purchase History',
        'offlineRequest' => 'Offline Request',
        'planDetails' => 'Plan Details',
        'offlineUploadFile' => 'Please attach a file of your offline payment receipt',
        'offlineDescriptionPlaceholder' => 'Provide details of your offline payment',
        'remark' => 'Remark',
        'trialExpireOn' => 'Trial Expires On',
        'selectDate' => 'Select Date',
        'amount' => 'Amount',
        'paymentDate' => 'Payment Date',
        'nextPaymentDate' => 'Next Payment Date',
        'licenceExpiresOn' => 'License Expires On',
        'planExpire' => 'Plan Expires On',
        'defaultPlan' => 'Your default plan.',
        'packageName' => 'Package Name',
        'choosePackageType' => 'Choose Package Type',
        'payOnce' => 'Pay One Time',
        'payMonthly' => 'Pay Monthly',
        'payAnnually' => 'Pay Annually',
        'branchLimit' => 'Branch Limit',
        'branchLimitInfo' => 'The restaurant can create a specified number of branches. Enter -1 for unlimited branches.',
        'licenseExpiresOn' => 'License Expires On',
        'additionalFeatures' => 'Additional Features',
        'noAdditionalFeatures' => 'No additional features available.',
        'currency' => 'Currency',
        'chooseCurrency' => 'Choose Currency',
    ],

    'billing' => [
        'name' => 'Name',
        'description' => 'Description',
        'deleteOfflinePaymentMethod' => 'Delete Offline Payment Method',
        'askDeleteOfflinePaymentMethod' => 'Are you sure you want to delete the offline payment method?',
        'offlinePaymentMethodDeleted' => 'Offline Payment Method Deleted',
        'addPaymentMethod' => 'Add Payment Method',
        'razorpay' => 'Razorpay',
        'stripe' => 'Stripe',
        'offline' => 'Offline Payment',
        'qr_code' => 'QR Code Payment',
        'paypal' => 'Paypal',
        'viewPaymentMethod' => 'View Payment Method',
        'offlinePaymentMethod' => 'Offline Payment Method',
        'restaurant' => 'Restaurant Name',
        'paymentDate' => 'Payment Date',
        'packageDetails' => 'Package Details',
        'transactionId' => 'Transaction ID',
        'paymentGateway' => 'Payment Gateway',
        'choosePlan' => 'Choose Plan',
        'noPaymentOptionEnable' => 'No payment options are enabled.',
        'choosePaymentMethod' => 'Choose Payment Method',
        'amount' => 'Amount',
        'package' => 'Package',
        'paymentBy' => 'Payment By',
        'paymentDone' => 'Payment Done',
        'created' => 'Created',
        'status' => 'Status',
        'receipt' => 'Receipt',
        'paymentDate' => 'Payment Date',
        'payOnline' => 'Pay Online',
        'billingCycle' => 'Billing Cycle',
        'paybyQr' => 'Pay by QR Code',
        'accountDetails' => 'Account Details :',
        'showOtherPaymentOption' => 'Show Other Payment Option',
        'bankTransfer' => 'Bank Transfer',
        'payOffline' => 'Pay Offline',
        'purchaseHistory' => 'Purchase History',
        'offlineRequest' => 'Offline Request',
        'generalSettings' => 'General Settings',
        'planDetails' => 'Plan Details',
        'currentPlan' => 'Current Plan Name',
        'daysLeft' => ':count Days Left',
        'licenseExpireOn' => 'License Expire On',
        'noPlanAssigned' => 'No Plan Assigned',
        'expired' => 'Expired',
        'currentPlanType' => 'Current Plan Type',
        'offlineUploadFile' => 'Please attach a file of your offline payment receipt',
        'offlineDescriptionPlaceholder' => 'Provide details of your offline payment',
        'nextPaymentDate' => 'Next Payment Date',
        'remark' => 'Remark',
        'monthly' => 'Monthly',
        'annually' => 'Annually',
        'lifetimeAccess' => 'Lifetime Access',
        'billed' => 'Billed',
        'free' => 'Free',
        'billedTo' => 'Billed To',
        'paid' => 'Paid',
        'total' => 'Total',
        'paidVia' => 'Paid Via',
        'acceptOfflineRequest' => 'Accept Offline Request',
        'rejectOfflineRequest' => 'Reject Offline Request',
        'pickYourPlan' => 'Pick Your Plan',
        'noPaymentMethodSelected' => 'No payment method selected.',
        'cancelImmediately' => 'Cancel Immediately',
        'endOfBillingCycle' => 'End of Billing Cycle',
        'expiringToday' => 'Expiring Today',

    ],

    'language' => [
        'languageCode' => 'Language Code',
        'languageName' => 'Language Name',
        'active' => 'Active',
        'rtl' => 'RTL',
        'addLanguage' => 'Add Language',
        'flagCode' => 'Flag Code',
        'flagCodeHelp' => 'Click here to get the flag code',
        'editLanguage' => 'Edit Language',
        'deleteLanguage' => 'Delete Language',
        'deleteLanguageMessage' => 'Are you sure you want to delete the language?',
        'defaultLanguage' => 'Default Language',
    ],

    'waiterRequest' => [
        'markCompleted' => 'Mark Attended',
        'doItLater' => 'Do it Later',
        'activeWaiterRequests' => 'Active Waiter Requests',
        'newWaiterRequests' => 'New Waiter Request',
        'newWaiterRequestForTable' => 'New Waiter Request for Table - :name',
        'activeWaiterRequestsCount' => 'Active Waiter Requests',
        'noWaiterRequest' => 'No waiter request found in this area.',
    ],

    'profile' => [
        'profileInfo' => 'Profile Information',
        'updateProfileInfo' => 'Update your account\'s profile information and email address.',
        'photo' => 'Photo',
        'selectNewPhoto' => 'Select A New Photo',
        'removePhoto' => 'Remove Photo',
        'name' => 'Name',
        'currentPassword' => 'Current Password',
        'newPassword' => 'New Password',
        'confirmPassword' => 'Confirm Password',
        'ensureAccountSecure' => 'Ensure your account is using a long, random password to stay secure.',
        'updatePassword' => 'Update Password',
        'twoFactorAuth' => 'Two Factor Authentication',
        'addSecurity' => 'Add additional security to your account using two factor authentication.',
        'finishEnablingTwoFactorAuth' => 'Finish enabling two factor authentication.',
        'notEnabledTwoFactorAuth' => 'You have not enabled two factor authentication.',
        'enabledTwoFactorAuth' => 'You have enabled two factor authentication.',
        'twoFactorAuthMessage' => 'When two factor authentication is enabled, you will be prompted for a secure, random token during authentication. You may retrieve this token from your phone\'s Google Authenticator application.',
        'finishEnablingTwoFactorAuthMessage' => 'To finish enabling two factor authentication, scan the following QR code using your phone\'s authenticator application or enter the setup key and provide the generated OTP code.',
        'setupKey' => 'Setup Key',
        'recoveryCodesMessage' => 'Store these recovery codes in a secure password manager. They can be used to recover access to your account if your two factor authentication device is lost.',
        'regenerateRecoveryCodes' => 'Regenerate Recovery Codes',
        'showRecoveryCodes' => 'Show Recovery Codes',
        'deleteAccount' => 'Delete Account',
        'permanentlyDeleteAccount' => 'Permanently delete your account.',
        'permanentlyDeleteAccountMessage' => 'Once your account is deleted, all of its resources and data will be permanently deleted. Before deleting your account, please download any data or information that you wish to retain.',
        'areYouSureDeleteAccount' => 'Are you sure you want to delete your account? Once your account is deleted, all of its resources and data will be permanently deleted. Please enter your password to confirm you would like to permanently delete your account.',
        'password' => 'Password',
    ],

    'modifier' => [
        'menuItems' => 'Menu Items',
        'menuCategories' => 'Menu Categories',
        'addItemModifier' => 'Add Item Modifier',
        'editItemModifier' => 'Edit Item Modifier',
        'isRequired' => 'Is Required',
        'sortOrder' => 'Sort Order',
        'addModifierGroup' => 'Add Modifier Group',
        'menuItemName' => 'Menu Item Name',
        'modifierName' => 'Modifier Name',
        'modifierDescription' => 'Modifier Description',
        'modifierPrice' => 'Modifier Price',
        'modifierType' => 'Modifier Type',
        'chooseModifierType' => 'Choose Modifier Type',
        'modifierCategory' => 'Modifier Category',
        'addModifierCategory' => 'Add Modifier Category',
        'editModifierCategory' => 'Edit Modifier Category',
        'deleteModifierCategory' => 'Delete Modifier Category',
        'modifierCategoryName' => 'Modifier Category Name',
        'modifierCategoryDescription' => 'Modifier Category Description',
        'deleteModifierMessage' => 'Are you sure you want to delete the modifier?',
        'deleteModifierCategoryMessage' => 'Are you sure you want to delete the modifier category?',
        'modifierHelp' => 'Fill in the details below to add a new modifier.',
        'modifierCategoryHelp' => 'Fill in the details below to add a new modifier category.',
        'deleteModifierGroup' => 'Delete Modifier Group',
        'deleteModifierGroupMessage' => 'Are you sure you want to delete the modifier group?',
        'updateItemModifier' => 'Update Item Modifier',
        'deleteItemModifier' => 'Delete Item Modifier',
        'deleteItemModifierMessage' => 'Are you sure you want to delete the item modifier?',
        'updateModifierGroup' => 'Update Modifier Group',
        'editModifierGroup' => 'Edit Modifier Group',
        'addModifierOption' => 'Add Modifier Option',
        'modifierGroup' => 'Modifier Group',
        'options' => 'Options',
        'name' => 'name',
        'description' => 'Description',
        'isAvailable' => 'Is Available',
        'selectMenuItem' => 'Select Menu Item',
        'modifierOptions' => 'Modifier Options',
        'price' => 'Price',
        'addModifierOption' => 'Add Modifier Option',
        'locations' => 'Locations',
        'selectMenuItem' => 'Select Menu Item',
        'addOn' => 'Add Modifiers',
        'optionName' => 'Option Name',
        'groupName' => 'Group Name',
        'required' => 'Required',
        'optional' => 'Optional',
        'itemModifiers' => 'Item Modifiers',
        'noMenuItemsFound' => 'No menu item found.',
        'allowMultipleSelection' => 'Allow Multiple Selection',
        'allowMultipleSelectionDescription' => 'Allow users to select multiple options',
        'selectModifierGroup' => 'Select Modifier Group',
    ],
];
